<?php $__env->startPush('color_css'); ?>
    
    <style>
    /* تنسيق عام */
body {
    background-color: #1a1a1a;
    font-family: 'Arial', sans-serif;
}

/* تهيئة القسم */
.hero-section {
    background: url("../images/hero-bg.jpg") no-repeat center center/cover;
    padding: 80px 0;
    position: relative;
}

.hero-section .overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.6);
}

.text-hero-7 h2 {
    color: #FFD700;
    font-size: 36px;
    font-weight: bold;
}

.text-hero-7 p {
    color: #fff;
    font-size: 18px;
}

/* تصميم صندوق تسجيل الدخول */
.common_author_boxed {
    background: #222;
    padding: 40px;
    border-radius: 10px;
    box-shadow: 0 0 15px rgba(255, 215, 0, 0.3);
    text-align: center;
}

.common_author_heading h3 {
    font-size: 24px;
    font-weight: bold;
    color: #FFD700;
}

.common_author_heading h2 {
    font-size: 20px;
    color: #fff;
}

/* تنسيق الحقول */
.form-group input {
    /* background: #333; */
    color: #fff;
    /* border: 1px solid #FFD700; */
    border-radius: 5px;
    padding: 12px;
}

.form-group input::placeholder {
    color: #bbb;
}

/* تنسيق زر تسجيل الدخول */
.common_form_submit button {
    background: #8A1538;
    color: #fff;
    border: none;
    padding: 12px;
    font-size: 18px;
    font-weight: bold;
    border-radius: 5px;
    transition: background 0.3s ease-in-out;
}

.common_form_submit button:hover {
    background: #FFD700;
    color: #000;
}

/* تنسيق رابط نسيان كلمة المرور */
a.text-white {
    color: #FFD700 !important;
}

/* تنسيق رابط التسجيل */
.text-center a {
    color: #FFD700;
    font-weight: bold;
}

.text-center a:hover {
    text-decoration: underline;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="hero-section">
    <div class="overlay"></div>
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-md-10 text-center">
                <div class="text-hero-7">
                    <h2 data-aos="zoom-in" data-aos-duration="1000">
                        <?php echo e(\App\Helpers\TranslationHelper::translate('Login')); ?>

                    </h2>
                    
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Login Section -->
<section id="common_author_area" class="section_padding" style="margin-top: 50px;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="common_author_boxed">
                    <div class="common_author_heading text-center">
                        <h3 class="text-white"><?php echo e(\App\Helpers\TranslationHelper::translate('Login to your account')); ?></h3>
                        <h2 class="text-white"><?php echo e(\App\Helpers\TranslationHelper::translate('Stay connected with us')); ?></h2>
                    </div>
                    <div class="common_author_form">
                        <form action="<?php echo e(route('user.login.submit')); ?>" method="post" id="login_form">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mb-3">
                                <input type="text" name="username" class="form-control" placeholder="<?php echo e(\App\Helpers\TranslationHelper::translate('Enter email or username')); ?>" required>
                                <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group mb-3">
                                <input type="password" name="password" class="form-control" placeholder="<?php echo e(\App\Helpers\TranslationHelper::translate('Enter password')); ?>" required>
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                
                            </div>
                            <div class="common_form_submit text-center">
                                <button type="submit" class="btn btn-primary w-100" style="background-color: #8A1538; border: none; padding: 12px; font-size: 18px; font-weight: bold;"><?php echo e(\App\Helpers\TranslationHelper::translate('Login')); ?></button>
                            </div>
                            <div class="text-center mt-3">
                                <p class="text-white"><?php echo e(\App\Helpers\TranslationHelper::translate('Don\'t have an account?')); ?> 
                                    <a href="<?php echo e(route('user.register.form')); ?>" class="text-decoration-none" style="color: #FFD700; font-weight: bold;"><?php echo e(\App\Helpers\TranslationHelper::translate('Register now')); ?></a>
                                </p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>





<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\couronne\resources\views/front/pages/user_dashboard/auth/login.blade.php ENDPATH**/ ?>