<?php $__env->startSection('content'); ?>



<div class="overlay" id="overlay">
    <div class="container h-100">
        <div class="row align-items-center justify-content-center h-100">
            <div class="col-md-4 text-center text-md-start">
                <p class="coming-soon"><?php echo e(\App\Helpers\TranslationHelper::translate('This content will be available soon')); ?></p>
            </div>
            <div class="col-md-4 text-center">
                <button class="lock-btn" onclick="unlockContent()">
                    <img src="<?php echo e(asset('front/assets/img/lock.png')); ?>" alt="" class="img-fluid">
                </button>
            </div>
        </div>
    </div>
</div>
<main>
    <section class="card-one" style="padding-top: 15px;">
        <div class="container">
            <div class="d-flex justify-content-center align-items-center">
                <h2><?php echo e(\App\Helpers\TranslationHelper::translate('Imperial Cards')); ?></h2>
            </div>
            <div class="row pt-5" style="padding-top: 1rem !important;">
                <?php $__currentLoopData = $imperial_cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imperial_card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4">
                        <div class="product-card" data-aos="fade-up" data-aos-duration="1000" style="width: 100%">
                            <img src="<?php echo e($imperial_card->getFirstMediaUrl('cards')); ?>" alt="Product Image">
                            <h3><?php echo e($imperial_card->categorycolid->name); ?></h3>
                            
                            <div class="product-details product-details-<?php echo e($imperial_card->id); ?>" style="display: none; background: #470d14; color: #fff; padding: 15px; border-radius: 10px; margin-top: 10px;">
                                <div style="max-height: 150px; overflow-y: auto; padding-right: 10px;">
                                    <?php echo strip_tags($imperial_card->des); ?>

                                </div>
                            </div>

                            <div class="d-flex justify-content-between mt-3">
                                <!-- Description Button -->
                                <a href="javascript:void(0)"
                                    class="custom-button btn-custom description-toggle more-info-toggle"
                                    data-target=".product-details-<?php echo e($imperial_card->id); ?>">
                                    <?php echo e(\App\Helpers\TranslationHelper::translate('Description')); ?>

                                </a>
                                <!-- Learn More Button -->
                                <a href="<?php echo e(route('show-card', ['id' => $imperial_card->id])); ?>"
                                    class="custom-button btn-custom">
                                    <?php echo e(\App\Helpers\TranslationHelper::translate('Details')); ?>

                                </a>
                            </div>
                             
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
</main>

<style>
    .btn-custom {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 48%; /* يجعل الزرين بنفس الحجم */
        padding: 12px;
        background-color: rgba(255, 255, 255, 0.2);
        color: #fff;
        border-radius: 5px;
        text-decoration: none;
        font-weight: bold;
        text-align: center;
        transition: 0.3s;
    }

    .btn-custom:hover {
        background-color: #470d14;
        color: #fff;
    }

    .product-details .d-flex {
        gap: 10px; /* يضيف مسافة صغيرة بين الزرين */
    }
</style>


       <?php $__env->stopSection(); ?>

       
<?php $__env->startPush('js'); ?>


<script>
function unlockContent() {
    let overlay = document.getElementById("overlay");
    overlay.style.opacity = "0";

    setTimeout(() => {
        overlay.style.display = "none";
        document.getElementById("main-content").style.display = "block";
    }, 300);
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\couronne\resources\views/front/pages/imperial_card.blade.php ENDPATH**/ ?>