@extends('front.layouts.app')

@section('content')
    {{-- <div class="overlay" id="overlay">
        <div class="container h-100">
            <div class="row align-items-center justify-content-center h-100">
                <div class="col-md-4 text-center text-md-start">
                    <p class="coming-soon">
                        {{ \App\Helpers\TranslationHelper::translate('This content will be available soon') }}</p>
                </div>
                <div class="col-md-4 text-center">
                    <button class="lock-btn" onclick="unlockContent()">
                        <img src="{{ asset('front/assets/img/lock.png') }}" alt="" class="img-fluid">
                    </button>
                </div>
            </div>
        </div>
    </div> --}}
    <main>
        <section class="card-one" style="padding-top: 15px;">
            <div class="container">
                <div class="d-flex justify-content-center align-items-center">
                    <h2>{{ \App\Helpers\TranslationHelper::translate('Regular User Cards') }}</h2>
                </div>
                <div class="row pt-5" style="padding-top: 1rem !important;">
                    @foreach ($regular_cards as $regular_card)
                        <div class="col-md-3">
                            <div class="product-card" data-aos="fade-up" data-aos-duration="1000" style="width: 100%">
                                <img src="{{ $regular_card->getFirstMediaUrl('cards') }}" alt="Product Image 1">
                                <h3>{{ $regular_card->categorycolid->name }}</h3>
                                <div class="product-details product-details-{{ $regular_card->id }}"
                                    style="display: none; background: #470d14; color: #fff; padding: 10px; border-radius: 10px; margin-top: 10px;">
                                    <div style="max-height: 150px; overflow-y: auto; padding-right: 10px;">
                                        {!! strip_tags($regular_card->des) !!}
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3">
                                    <a href="javascript:void(0)"
                                        class="custom-button btn-custom description-toggle more-info-toggle"
                                        data-target=".product-details-{{ $regular_card->id }}">
                                        {{ \App\Helpers\TranslationHelper::translate('Description') }}
                                    </a>

                                    <a href="{{ route('show-card', ['id' => $regular_card->id]) }}"
                                        class="custom-button btn-custom">
                                        {{ \App\Helpers\TranslationHelper::translate('Details') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    </main>



    <style>
        .btn-custom {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 48%;
            padding: 12px;
            background-color: rgba(255, 255, 255, 0.2);
            color: #fff;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            text-align: center;
            transition: 0.3s;
        }

        .btn-custom:hover {
            background-color: #470d14;
            color: #fff;
        }

        .product-details .d-flex {
            gap: 10px;
        }
    </style>
@endsection



@push('js')
    {{-- <script>
        function unlockContent() {
            let overlay = document.getElementById("overlay");
            overlay.style.opacity = "0";

            setTimeout(() => {
                overlay.style.display = "none";
                document.getElementById("main-content").style.display = "block";
            }, 300);
        }
    </script> --}}
@endpush
