@extends('front.layouts.app')

@section('content')
    
{{-- <div class="overlay" id="overlay">
    <div class="container h-100">
        <div class="row align-items-center justify-content-center h-100">
            <div class="col-md-4 text-center text-md-start">
                <p class="coming-soon">{{ \App\Helpers\TranslationHelper::translate('This content will be available soon') }}</p>
            </div>
            <div class="col-md-4 text-center">
                <button class="lock-btn" onclick="unlockContent()">
                    <img src="{{ asset('front/assets/img/lock.png') }}" alt="" class="img-fluid">
                </button>
            </div>
        </div>
    </div>
</div> --}}

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="overlay"></div>
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-md-10 text-center">
                    <div class="text-hero-7">
                        <h2 data-aos="zoom-in" data-aos-duration="1000">
                            {{ setting('title', app()->getLocale()) }}
                        </h2>
                        <p data-aos="fade-up" data-aos-duration="1200">
                            {{ setting('title_tow', app()->getLocale()) }}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Us Section -->
    <section class="contact-us">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="text-contact" style="color:#fff !important;">
                        <h2 style="color: rgb(241, 196, 15);">
                            {{ \App\Helpers\TranslationHelper::translate('Royal Crown Vip News') }}
                        </h2>
                        {!! setting('description', app()->getLocale()) !!}

                    </div>
                </div>
                <div class="col-md-6" style="margin-top: 20px;">
                    <div class="img-contact">
                        <img src="{{ setting('image_one_news', 'en') }}" alt=""
                            style="height: 300px; object-fit: cover; border-radius: 12px; box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1);">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Videos Section -->
    {{-- <section class="news-section" style="padding: 40px 0;">
        <div class="container">
            <div class="row">
                @foreach ($news as $index => $new)
                    <div class="col-md-6 mb-4 d-flex justify-content-center">
                        <div
                            style="background-color: #a42249; box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1); padding: 20px; border-radius: 12px; width: 100%; max-width: 540px;">
                            <video width="100%" height="250" controls style="border-radius: 12px;">
                                <source src="{{ $new->getFirstMediaUrl('newsnews_video') }}" type="video/mp4">
                            </video>
                            <div class="rc-post-content" style="text-align: center; margin-top: 10px;">
                                <div class="rc-meta d-flex justify-content-center align-items-center mb-2"
                                    style="gap: 5px;">
                                    <i class="fa-solid fa-calendar-days" style="color: #fff;"></i>
                                    <span style="color: #fff;">{{ $new->created_at->format('Y-m-d') }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section> --}}

    @php
    $locale = app()->getLocale();
@endphp

<section class="news-section" style="padding: 40px 0;">
    <div class="container">
        <div class="row">
            @foreach ($news as $index => $new)
                @php
                    $videoUrl = $new->getFirstMediaUrl('newsnews_video_' . $locale);
                @endphp

                @if ($videoUrl)
                    <div class="col-md-6 mb-4 d-flex justify-content-center">
                        <div
                            style="background-color: #a42249; box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1); padding: 20px; border-radius: 12px; width: 100%; max-width: 540px;">
                            <video width="100%" height="250" controls style="border-radius: 12px;">
                                <source src="{{ $videoUrl }}" type="video/mp4">
                                {{ __('Your browser does not support the video tag.') }}
                            </video>
                            <div class="rc-post-content" style="text-align: center; margin-top: 10px;">
                                <div class="rc-meta d-flex justify-content-center align-items-center mb-2"
                                    style="gap: 5px;">
                                    <i class="fa-solid fa-calendar-days" style="color: #fff;"></i>
                                    <span style="color: #fff;">{{ $new->created_at->format('Y-m-d') }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    </div>
</section>




    {{-- <section class="latest-blogs" style="padding: 40px 0;">
    <div class="container">
        <h2 class="text-center mb-4" style="color: rgb(241, 196, 15);">
            {{ \App\Helpers\TranslationHelper::translate('Latest Articles') }}
        </h2>
        <div class="row">
      
            @foreach ($blogs as $blog)
                <div class="col-md-4 mb-4 d-flex">
                    <div class="card" style="border-radius: 12px; box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1); display: flex; flex-direction: column; height: 100%;">
                        <img src="{{ $blog->getFirstMediaUrl('blogs_image') }}" alt="{{ $blog->name }}" class="card-img-top" style="height: 200px; object-fit: cover; border-radius: 12px 12px 0 0;">
                        <div class="card-body" style="flex-grow: 1; display: flex; flex-direction: column;">
                            <h5 class="card-title" style="color: #a42249;">{{ $blog->name }}</h5>
                            <p class="card-text" style="flex-grow: 1;">{{ Str::words(strip_tags($blog->description), 30, '...') }}</p>
                            <a href="{{ route('news-video') }}" class="btn btn-primary" style="background-color: #a42249; border: none; align-self: flex-end;">
                                {{ \App\Helpers\TranslationHelper::translate('More Articles') }}
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section> --}}
@endsection

@push('js')
@endpush
