<?php

namespace App\Services;

use App\Helpers\ReorderHelper;
use App\Models\CharitableWork;
use App\Models\Tag;

class  CharitableWorkService
{

    public function createCharitableWork($data)
    {
        $charitableWork = CharitableWork::create([
            'description' => $data['description'] ?? null,
        ]);
        $this->storeFiles($charitableWork, $data);
    }

    private function storeFiles(CharitableWork $charitableWork, array $data)
    {
        if (isset($data['image'])) {
            $charitableWork->storeFile($data['image'], '_image');
        }
        if (isset($data['charitableWork_video_one']) && is_array($data['charitableWork_video_one'])) {
            foreach ($data['charitableWork_video_one'] as $langKey => $videoFile) {
                if ($videoFile) {
                    $mediaKey = 'charitableWork_video_one_' . $langKey;
                    $charitableWork->storeFile($videoFile, $mediaKey);
                }
            }
        }
    }



    public function updateCharitableWork(CharitableWork $charitableWork, array $data)
    {
        // dd($data);
        $charitableWork->update([
            'description' => $data['description'] ?? $charitableWork->description,
        ]);
        $this->updateFiles($charitableWork, $data);
    }



    private function updateFiles(CharitableWork $charitableWork, array $data)
    {
        if (isset($data['image'])) {
            $charitableWork->updateFile($data['image'], '_image');
        }

        if (isset($data['charitableWork_video_one']) && is_array($data['charitableWork_video_one'])) {
            foreach ($data['charitableWork_video_one'] as $langKey => $videoFile) {
                if ($videoFile) {
                    $mediaKey = 'charitableWork_video_one_' . $langKey;
                    $charitableWork->clearMediaCollection($mediaKey);
                    $charitableWork->storeFile($videoFile, $mediaKey);
                }
            }
        }
    }







    public function deleteCharitableWork(CharitableWork $charitableWork)
    {
        $charitableWork->delete();
    }


    

  

    public function reorder($charitableWork, $label, $path, $max_num)
    {
        return ReorderHelper::reorder($charitableWork, $label, $path, $max_num);
    }

    public function saveReorder($all_entries, $charitableWork)
    {
        return ReorderHelper::saveReorder($all_entries, $charitableWork);
    }

}
