<?php

namespace App\Models;

use App\Traits\HandleUploadFile;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\Translatable\HasTranslations;

class Card extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia, HandleUploadFile , HasTranslations;


    protected $table = 'cards';
    
    protected $fillable = ['title', 'des' , 'category_id' , 'categorycolid_id' , 'category_card' , 'price'];

    protected $guarded = ['id'];

    public $translatable = ['title', 'des' ];

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('card_video')->singleFile();
        $this->addMediaCollection('card_video_tow')->singleFile();
    }


    public function deleteFile($collectionName)
    {
        $this->clearMediaCollection($collectionName);
    }

    public function scopeOrdered($q)
    {
        return $q->orderBy('id', 'asc');
    }

    public function categories()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function categorycolid()
    {
        return $this->belongsTo(Categorycolid::class, 'categorycolid_id');
    }


    // public function orderCard()
    // {
    //     return $this->belongsTo(OrderCard::class, 'card_id', 'id');
    // }
    public function orderCard()
    {
        return $this->hasMany(OrderCard::class, 'card_id', 'id');
    }

    // App\Models\Card.php

    // public function getMediaUrlFromCollection(string $collectionName): ?string
    // {
    //     $media = $this->media()->where('collection_name', $collectionName)->first();

    //     return $media && isset($media->uuid) ? $media->uuid : null;
    // }

    public function getMediaUrlFromCollection(string $collectionName): ?string
    {
       
        $media = $this->media()->where('collection_name', $collectionName)->first();
      
        return $media ? $media->getUrl() : null;
    }

    public function getExternalMediaUrl(string $collectionName): ?string
    {
        $media = $this->getMedia($collectionName)->first();
        return $media?->uuid;
    }



    // public function getMediaUrlFromCollection($collection)
    // {
    //     $mediaItem = $this->getMedia($collection)->first();

    //     if (!$mediaItem) {
    //         return null;
    //     }

    //     // If disk is external, return uuid as full URL
    //     if ($mediaItem->disk === 'external') {
    //         return $mediaItem->uuid;
    //     }

    //     return $mediaItem->getFullUrl();
    // }




}
