<?php

namespace App\Http\Requests\Admin\News;

use App\Helpers\TranslationHelper;
use Illuminate\Foundation\Http\FormRequest;

class NewsRequest extends FormRequest
{
    /**
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    // public function rules(): array
    // {
    //     return [
    //         'news_video' => 'nullable|mimes:mp4,mov,avi,wmv|max:512000',
    //         ];
    // }
    public function rules(): array
    {
        $rules = [];
        foreach (config('language') as $key => $lang) {
            $rules["news_video.$key"] = 'nullable|mimes:mp4,mov,avi,wmv|max:512000'; // الحجم 500 ميجا تقريباً
        }
        return $rules;
    }


    public function messages(): array
    {
        return [

            'image.required' => TranslationHelper::translate('Please Upload Image'),
            'image.image' => TranslationHelper::translate('Image is Not Valid'),
            'image.mimes' => TranslationHelper::translate('Image Type is Not Valid'),

            'news_video.max' => 'حجم الفيديو يجب ألا يتجاوز 20 ميجابايت.',
        ];
    }
}
