<?php

namespace App\Http\Requests\Admin\CharitableWork;

use App\Helpers\TranslationHelper;
use Illuminate\Foundation\Http\FormRequest;

class CharitableWorkRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    // public function rules(): array
    // {
    //     return [

    //         'charitableWork_video_one' => 'nullable|mimes:mp4,mov,avi,wmv|max:512000',
    //     ];
    // }

    public function rules(): array
    {
        $rules = [];
    
        // $rules['image'] = 'required_without_all:' . implode(',', array_map(fn($key) => "charitableWork_video_one.$key", array_keys(config('language')))) . '|image';
        $rules['image'] = 'required_without';

        foreach (config('language') as $key => $lang) {
            $rules["charitableWork_video_one.$key"] = 'nullable|file|mimetypes:video/mp4,video/quicktime|max:512000'; // 500MB
            $rules["description.$key"] = 'nullable';
        }
    
        return $rules;
    }

    public function messages(): array
    {
        return [
            'image.required_without_all' => TranslationHelper::translate('Please upload an image or a video in any language'),
            'image.image' => TranslationHelper::translate('The file must be an image'),
            'image.mimes' => TranslationHelper::translate('Allowed image formats: jpeg, png, jpg, gif, svg'),
            'image.max' => TranslationHelper::translate('Maximum image size is 2MB'),

            'charitableWork_video_one.*.max' => 'حجم الفيديو يجب ألا يتجاوز 500 ميجابايت.',
            'charitableWork_video_one.*.mimetypes' => 'صيغة الفيديو يجب أن تكون mp4 أو mov',
            'description.*.string' => TranslationHelper::translate('Description must be a string'),
        ];
    }



    // public function rules(): array
    // {
    //     $rules = [];
    //     foreach (config('language') as $key => $lang) {
    //         $rules["charitableWork_video_one.$key"] = 'nullable';
    //     }
    //     return $rules;
    // }

    // public function messages(): array
    // {
    //     return [
    //         'image.required_without' => TranslationHelper::translate('Please Upload Image'),
    //         'description.string' => TranslationHelper::translate('Description must be a string'),
    //         'charitableWork_video_one.max' => 'حجم الفيديو يجب ألا يتجاوز 500 ميجابايت.',
    //     ];
    // }
}
