<?php

namespace App\Http\Requests\Admin\Card;

use App\Helpers\TranslationHelper;
use Illuminate\Foundation\Http\FormRequest;

class CardRequest extends FormRequest
{
    /**
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
   

    public function rules(): array
    {
        return [
            // 'card_video_ar' => 'nullable|mimes:mp4,mov,avi,wmv|max:102400', // 100MB
            'card_video_ar' => 'nullable|string|url',
            'card_video_en' => 'nullable|string|url',
            'card_video_fr' => 'nullable|string|url',

            'card_video_tow_ar' => 'nullable|string|url',
            'card_video_tow_en' => 'nullable|string|url',
            'card_video_tow_fr' => 'nullable|string|url',

            'image' => request()->isMethod('post')
                ? 'required|image|mimes:jpeg,png,jpg,gif,svg'
                : 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
                // : 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

            'des.ar' => 'required',
            'des.en' => 'required',
            'des.fr' => 'required',

            'categorycolid_id' => 'required',
            'category_card' => 'required',

            'delete_card_video_ar' => 'sometimes',
            'delete_card_video_en' => 'sometimes',
            'delete_card_video_fr' => 'sometimes',

            'delete_card_video_tow_ar' => 'sometimes',
            'delete_card_video_tow_en' => 'sometimes',
            'delete_card_video_tow_fr' => 'sometimes',
        ];
    }

    // public function rules(): array
    // {
    //     return [
    //         'card_video_ar' => 'nullable|mimes:mp4,mov,avi,wmv|max:102400', // 100MB
    //         'card_video_en' => 'nullable|mimes:mp4,mov,avi,wmv|max:102400',
    //         'card_video_fr' => 'nullable|mimes:mp4,mov,avi,wmv|max:102400',

    //         'card_video_tow_ar' => 'nullable|mimes:mp4,mov,avi,wmv|max:102400',
    //         'card_video_tow_en' => 'nullable|mimes:mp4,mov,avi,wmv|max:102400',
    //         'card_video_tow_fr' => 'nullable|mimes:mp4,mov,avi,wmv|max:102400',

    //         'image' => request()->isMethod('post')
    //             ? 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048'
    //             : 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

    //         'des.ar' => 'required',
    //         'des.en' => 'required',
    //         'des.fr' => 'required',

    //         'categorycolid_id' => 'required',
    //         'category_card' => 'required',
    //         'delete_card_video_en' => 'sometimes',



    //         'delete_card_video_ar' => 'sometimes',
    //         'delete_card_video_en' => 'sometimes',
    //         'delete_card_video_fr' => 'sometimes',

    //         'delete_card_video_tow_ar' => 'sometimes',
    //         'delete_card_video_tow_en' => 'sometimes',
    //         'delete_card_video_tow_fr' => 'sometimes',

    //         // 'delete_card_video_' => 'sometimes',
    //         // 'delete_card_video_tow_' => 'sometimes',
    //     ];
    // }

    public function messages(): array
    {
        return [

            'image.required' => TranslationHelper::translate('Please Upload Image'),
            'image.image' => TranslationHelper::translate('Image is Not Valid'),
            'image.mimes' => TranslationHelper::translate('Image Type is Not Valid'),

            'des.ar.required' => TranslationHelper::translate('Please Upload des ar'),
            'des.en.required' => TranslationHelper::translate('Please Upload des en'),
            'des.fr.required' => TranslationHelper::translate('Please Upload des fr'),

            'categorycolid_id.required' => TranslationHelper::translate('Please Upload categorycolid_id'),
            'category_card.required' => TranslationHelper::translate('Please Upload category_card'),

            'card_video_ar.max' => 'حجم الفيديو (عربي) يجب ألا يتجاوز 100 ميجابايت.',
            'card_video_ar.mimes' => 'صيغة الفيديو (عربي) يجب أن تكون mp4 أو mov أو avi أو wmv.',

            'card_video_en.max' => 'Video size (English) must not exceed 100 MB.',
            'card_video_en.mimes' => 'Video format (English) must be mp4, mov, avi, or wmv.',

            'card_video_fr.max' => 'La taille de la vidéo (Français) ne doit pas dépasser 100 Mo.',
            'card_video_fr.mimes' => 'Le format de la vidéo (Français) doit être mp4, mov, avi ou wmv.',

            'card_video_tow_ar.max' => 'حجم الفيديو الثاني (عربي) يجب ألا يتجاوز 100 ميجابايت.',
            'card_video_tow_ar.mimes' => 'صيغة الفيديو الثاني (عربي) يجب أن تكون mp4 أو mov أو avi أو wmv.',

            'card_video_tow_en.max' => 'Second video size (English) must not exceed 100 MB.',
            'card_video_tow_en.mimes' => 'Second video format (English) must be mp4, mov, avi, or wmv.',

            'card_video_tow_fr.max' => 'La taille de la deuxième vidéo (Français) ne doit pas dépasser 100 Mo.',
            'card_video_tow_fr.mimes' => 'Le format de la deuxième vidéo (Français) doit être mp4, mov, avi ou wmv.',
        ];
    }


    // public function messages(): array
    // {
    //     return [

    //         'image.required' => TranslationHelper::translate('Please Upload Image'),
    //         'image.image' => TranslationHelper::translate('Image is Not Valid'),
    //         'image.mimes' => TranslationHelper::translate('Image Type is Not Valid'),
    //          'des.ar.required' => TranslationHelper::translate('Please Upload des ar'),
    //         'des.en.required' => TranslationHelper::translate('Please Upload des en'),
    //         'des.fr.required' => TranslationHelper::translate('Please Upload des fr'),
    //         'categorycolid_id.required' => TranslationHelper::translate('Please Upload categorycolid_id'),
    //         'category_card.required' => TranslationHelper::translate('Please Upload category_card'),
    //         'card_video.max' => 'حجم الفيديو يجب ألا يتجاوز 100 ميجابايت.',
    //         'card_video_tow.max' => 'حجم الفيديو يجب ألا يتجاوز 100 ميجابايت.',
    //         'card_video.mimes' => 'صيغة الفيديو يجب أن تكون mp4 أو mov أو avi أو wmv.',
    //         'card_video_tow.mimes' => 'صيغة الفيديو يجب أن تكون mp4 أو mov أو avi أو wmv.',


    //     ];
    // }
}
