<?php

namespace App\Http\Requests\Admin\About;

use App\Helpers\TranslationHelper;
use Illuminate\Foundation\Http\FormRequest;

class AboutRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    // public function rules(): array
    // {
    //     return [
    //         'title.ar' => 'nullable|max:255',
    //         'title.en' => 'nullable|max:255',


    //         'description.ar' => 'nullable',
    //         'description.en' => 'nullable',

    //         'description_story.ar' => 'nullable',
    //         'description_story.en' => 'nullable',


    //         'description_see_us.ar' => 'nullable',
    //         'description_see_us.en' => 'nullable',


    //         'description_our_mission.ar' => 'nullable',
    //         'description_our_mission.en' => 'nullable',


    //         'description_about_the_plan.ar' => 'nullable',
    //         'description_about_the_plan.en' => 'nullable',

    //         'image' => 'nullable',
    //         'meta_image' => 'nullable',





    //     ];
    // }
    // public function messages(): array
    // {
    //     return [
    //         'title.ar.required' => TranslationHelper::translate('Please Enter Name in Arabic'),
    //         'title.en.required' => TranslationHelper::translate('Please Enter Name in English'),
    //         'description.ar.required' => TranslationHelper::translate('Please Enter Description in Arabic'),
    //         'description.en.required' => TranslationHelper::translate('Please Enter Description in English'),

    //         'meta_image.image' => TranslationHelper::translate('Image is Not Valid'),
    //         'meta_image.mimes' => TranslationHelper::translate('Image Type is Not Valid'),
    //         'meta_title.ar.max' => TranslationHelper::translate('Meta Title in Arabic is Too Long'),
    //         'meta_title.en.max' => TranslationHelper::translate('Meta Title in English is Too Long'),
    //         'meta_description.ar.max' => TranslationHelper::translate('Meta Description in Arabic is Too Long'),
    //         'meta_description.en.max' => TranslationHelper::translate('Meta Description in English is Too Long'),
    //         'meta_tags.ar.max' => TranslationHelper::translate('Meta Tags in Arabic is Too Long'),
    //         'meta_tags.en.max' => TranslationHelper::translate('Meta Tags in English is Too Long'),
    //         'alt_text.ar.max' => TranslationHelper::translate('Alt Text in Arabic is Too Long'),
    //         'alt_text.en.max' => TranslationHelper::translate('Alt Text in English is Too Long'),

    //     ];
    // }
    public function rules(): array
    {
        $rules = [];
        $languages = config('language');

        $translatableFields = [
            'title' => 'max:255|nullable',
            'description' => 'nullable',
            'description_story' => 'nullable',
            'description_see_us' => 'nullable',
            'description_our_mission' => 'nullable',
            'description_about_the_plan' => 'nullable',
        ];

        foreach ($languages as $key => $lang) {
            foreach ($translatableFields as $field => $validation) {
                $rules["{$field}.{$key}"] = $validation;
            }
        }

        $rules['image'] = 'nullable';
        $rules['meta_image'] = 'nullable|image|mimes:jpg,jpeg,png,webp';

        return $rules;
    }

    public function messages(): array
    {
        $messages = [];
        $languages = config('language');

        foreach ($languages as $key => $lang) {
            $langName = __('methods.' . $lang);

            $messages["title.$key.required"] = TranslationHelper::translate("Please Enter Name in $langName");
            $messages["description.$key.required"] = TranslationHelper::translate("Please Enter Description in $langName");

            $messages["meta_title.$key.max"] = TranslationHelper::translate("Meta Title in $langName is Too Long");
            $messages["meta_description.$key.max"] = TranslationHelper::translate("Meta Description in $langName is Too Long");
            $messages["meta_tags.$key.max"] = TranslationHelper::translate("Meta Tags in $langName is Too Long");
            $messages["alt_text.$key.max"] = TranslationHelper::translate("Alt Text in $langName is Too Long");
        }

        $messages['meta_image.image'] = TranslationHelper::translate('Image is Not Valid');
        $messages['meta_image.mimes'] = TranslationHelper::translate('Image Type is Not Valid');

        return $messages;
    }
}
