<?php

namespace App\Http\Controllers\Front;

use App\Helpers\TranslationHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\Front\Booking\ApplyFormRequest;
use App\Http\Requests\Front\Flight\FlightMultiSearchRequest;
use App\Http\Requests\Front\Flight\FlightSearchRequest;
use App\Http\Requests\Front\ProgrammeBooking\ProgrammeBookingCheckoutRequest;
use App\Models\About;
use App\Models\AirMaster;
use App\Models\Airport;
use App\Models\Blog;
use App\Models\Card;
use App\Models\Category;
use App\Models\Categorygallery;
use App\Models\CharitableWork;
use App\Models\City;
use App\Models\Contact;
use App\Models\Country;
use App\Models\Gallery;
use App\Models\HotelCity;
use App\Models\Informationflight;
use App\Models\Informationhotel;
use App\Models\Informationtour;
use App\Models\Message;
use App\Models\News;
use App\Models\Privacypolicy;
use App\Models\Programme;
use App\Models\ProgrammeBooking;
use App\Models\Project;
use App\Models\Setting;
use App\Models\Tag;
use App\Models\Termsandcondition;
use App\Models\Testimonial;
use App\Models\TourType;
use App\Models\User;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\File;


class WebController extends Controller
{

    public function index()
    {

        $about = About::first();
        $regular_cards = Card::where('category_card', 'regular')->get();
        
        $royal_cards = Card::where('category_card', 'royal')->get();

        $imperial_cards = Card::where('category_card', 'imperial')->get();

        $projects = Project::get();
         return view('front.index', get_defined_vars());
    }


    public function news_video()
    {
        $news = News::get();
        $blogs = Blog::get();
        return view('front.pages.news_video', get_defined_vars());
    }

    // public function projectShow($id)
    // {
    //     $projects = Project::find($id);
    //     return view('front.pages.projects', compact('projects'));
    // }

    public function projectShow($id)
    {
        $project = Project::find($id);
        return view('front.pages.projects', compact('project'));
    }




    public function searchHotelCities(Request $request)
    {
        $keyword = $request->keyword;
        try {
            if ($keyword != null) {
                $data = HotelCity::where('display_name', 'like', '%' . $keyword . '%')->orderBy('name', 'asc')->limit(10)->get();
                return response()->json(['status' => 1, 'msg' => 'Hotel Cities Data  !!', 'data' => $data]);

            } else {
                return response()->json(['status' => 0, 'msg' => 'Some Error Happened .. Please Try Again']);
            }
        } catch (\Exception $ex) {
            DB::rollBack();
            return response()->json(['status' => 0, 'msg' => 'Some Error Happened .. Please Try Again']);
        }
    }





    public function searchAirports(Request $request)
    {
        $keyword = $request->keyword;
        try {
            if ($keyword != null) {
                $data = Airport::
                where('name->en', 'like', '%' . $keyword . '%')
                    ->orWhere('name->ar', 'like', '%' . $keyword . '%')
                    ->orWhere('air_code', 'like', '%' . $keyword . '%')
                    ->orWhere('country_name->en', 'like', '%' . $keyword . '%')
                    ->orWhere('city_name->en', 'like', '%' . $keyword . '%')
                    ->orWhere('country_name->ar', 'like', '%' . $keyword . '%')
                    ->orWhere('city_name->ar', 'like', '%' . $keyword . '%')
                    ->orderBy('name', 'asc')->limit(20)->get();
                return response()->json(['status' => 1, 'msg' => 'Airports Data  !!', 'data' => $data]);

            } else {
                return response()->json(['status' => 0, 'msg' => 'Some Error Happened .. Please Try Again']);
            }
        } catch (\Exception $ex) {
            DB::rollBack();
            return response()->json(['status' => 0, 'msg' => \App\Helpers\TranslationHelper::translate('Some Error Happened .. Please Try Again')]);
        }
    }











    public function gallery($id)
    {
        $category = Categorygallery::find($id);
        $galleries = Gallery::where('categorygallery_id', $id)->get();
        return view('front.pages.gallery', compact('category', 'galleries'));
    }


    public function photo_gallery()
    {
        $photoGallery = Categorygallery::get();
        return view('front.pages.photo_gallery', compact('photoGallery'));
    }


    // public function trip()
    // {
    //     return view('front.pages.trip', get_defined_vars());
    // }


    // public function trip_details()
    // {
    //     return view('front.pages.trip_details', get_defined_vars());
    // }

    public function all_about_us()
    {
        $about_us = Testimonial::all();
        $cities = City::with('country')->latest()->take(8)->get();
        return view('front.pages.about_us', get_defined_vars());
    }


    public function about()
    {
        $about = About::first();
        return view('front.pages.about', get_defined_vars());
    }


    public function privacypolicy()
    {
        $privacypolicy = Privacypolicy::first();
        return view('front.pages.privacypolicy', get_defined_vars());
    }

    public function termsandcondition()
    {
        $termsandcondition = Termsandcondition::first();
        return view('front.pages.termsandcondition', get_defined_vars());
    }


    


    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|regex:/^\d{11}$/|max:11',
            'email' => 'required|email|max:255',
            'message' => 'required|string',
        ], [
            'name.required' => 'The name field is required.',
            'name.string' => 'The name must be a string.',
            'name.max' => 'The name must not be greater than 255 characters.',
            'phone.required' => 'The phone field is required.',
            'phone.regex' => 'The phone must be a valid phone number.',
            'phone.max' => 'The phone must not be greater than 11 characters.',
            'email.required' => 'The email field is required.',
            'email.email' => 'The email must be a valid email address.',
            'email.max' => 'The email must not be greater than 255 characters.',
            'message.required' => 'The message field is required.',
            'message.string' => 'The message must be a string.',
        ]);

        Message::create([
            'name' => $request->name,
            'phone' => $request->phone,
            'email' => $request->email,
            'message' => $request->message,
        ]);

        session()->flash('success', TranslationHelper::translate('Your Message has been sent'));

        return redirect()->back();
    }


    

    public function contact_us()
    {
        $about = About::first();
        $contact = Contact::first();
        return view('front.pages.contact', get_defined_vars());
    }

    public function charitable_Works()
    {
        $charitableWorks = CharitableWork::get();
        return view('front.pages.charitable_Works', get_defined_vars());
    }

       public function royalCrownCoin()
    {
        // $charitableWorks = CharitableWork::get();
        return view('front.pages.royal_crown_coin', get_defined_vars());
    }

    


    public function readExcelFile()
    {
        // Path to your Excel file in the public/assets directory
//        $filePath = public_path('assets/your-file.xlsx');

        // Check if the file exists
        $filePath = public_path('sheets/city_master.xlsx');
        $name = 'city_master';

        if (!File::exists($filePath)) {
            return "File not found!";
        }

        // Load the file and get the data as a collection
        $data = json_decode(Excel::toCollection(null, $filePath));

        // Now you can manipulate $data as needed
        // Example: displaying the first few rows
        foreach ($data[0] as $row) {
            DB::table('cities')->updateOrInsert([
                'id' => $row[0],
                'code' => $row[1],
                'name_en' => $row[2],
                'name_fr' => $row[3]
            ]);
        }
//        foreach ($data[0] as $row) {
//            DB::table('cities')->updateOrInsert([
//                'id' => $row[0],
//                'country_id' => $row[1],
//                'country_code' => $row[2],
//                'city_id' => $row[4],
//                'city_code' => $row[3],
//                'airport_name' => $row[5],
//                'airport_iata_code' => $row[6],
//                'is_active' => $row[7],
//                'en' => $row[12],
//                'ar' => $row[13],
//                'lat' => $row[14],
//                'lng' => $row[15],
//                'timezone_off_set' => $row[17],
//            ]);
//        }
//        return $data[0][4][0];


//        $check_cache = Cache::remember($name, 60, function () use ($data) {
//            return $data;
//        });
//
//        return Cache::get($name);

//        return response()->json($data);
    }


    public function searchCategory(Request $request)
    {
        // البحث عن القسم بالاسم
        $categories = Category::where('name', 'LIKE', '%' . $request->input('search') . '%')->get();

        // $categories = Category::limit(5)->get();
        // التحقق إذا تم العثور على أي قسم
        if ($categories->isEmpty()) {
            // إذا لم يتم العثور على أي قسم
            return redirect()->back()->with('error', 'No category found');
        }

        // إذا تم العثور على قسم، نعيد توجيه المستخدم إلى صفحة الأقسام مع تمرير البيانات
        return view('front.pages.blog.sher_blogs_category', compact('categories'));
    }


    public function applyForm(ApplyFormRequest $request, $id)
    {
        //        return $request;
        $check_in = $request->check_in;
        $programme = Programme::query()->active()->whereDate('valid_from', '<=', $check_in)->whereDate('valid_to', '>=', $check_in)
            ->find($id);
        //        return $programme;
        if ($programme) {
            //                return $room;
            $persons = $request->adult_search_count + $request->children_search_count + $request->infant_search_count;

            $data['programme'] = $programme;
            $data['adults'] = $request->adult_search_count;
            $data['children'] = $request->children_search_count;
            $data['infants'] = $request->infant_search_count;
            $data['persons'] = $persons;
            $data['check_in'] = $request->check_in;

            $data['price_before_discount'] = $persons * $programme->price;

            $data['discount'] = $programme->discount . ($programme->discount_type == 'percent' ? '%' : '');
            $data['discount_type'] = $programme->discount_type;
            $data['discount_value'] = $persons * getProgrammeDiscountInNumbers($programme);

            $data['price_after_discount'] = $persons * getProgrammePriceIfDiscountInNumbers($programme);

            $data['tax'] = $programme->tax;
            $data['tax_value'] = (($programme->tax / 100) * $data['price_after_discount']);

            $data['total'] = $data['tax_value'] + $data['price_after_discount'];

            return view('front.index', compact('data'));
        } else {
            return redirect()->back()->with(['error' => TranslationHelper::translate('This Programme is Not Available in This Date')]);
        }
    }

    public function bookingApply(ProgrammeBookingCheckoutRequest $request)
    {
        //        return $request;
        $check_in = $request->check_in;
        $programme = Programme::query()->active()->whereDate('valid_from', '<=', $check_in)->whereDate('valid_to', '>=', $check_in)
            ->find($request->programme_id);
        //            return $programme;
        //

        if ($programme) {


            $persons = $request->adult_search_count + $request->children_search_count + $request->infant_search_count;

            $data['user_id'] = auth()->user()->id;
            $data['programme_id'] = $programme->id;
            $data['adults'] = $request->adult_search_count;
            $data['children'] = $request->children_search_count;
            $data['infants'] = $request->infant_search_count;
            $data['persons'] = $persons;
            $data['check_in'] = $request->check_in;


            $data['price_before_discount'] = $persons * $programme->price;
            $data['discount'] = $programme->discount;

            $data['discount_type'] = $programme->discount_type;
            $data['discount_value'] = $persons * getRoomDiscountInNumbers($programme);

            $data['price_after_discount'] = $persons * getProgrammePriceIfDiscountInNumbers($programme);

            $data['tax'] = $programme->tax;
            $data['tax_value'] = (($programme->tax / 100) * $data['price_after_discount']);

            $data['total'] = $data['tax_value'] + $data['price_after_discount'];


            $data['payment_method'] = 'cash';
            $data['payment_status'] = 'unpaid';
            $data['f_name'] = $request->f_name;
            $data['l_name'] = $request->l_name;
            $data['email'] = $request->email;
            $data['phone'] = $request->phone;
            $data['note'] = $request->has('note') ? $request->note : '';

            $booking = ProgrammeBooking::create($data);
            return redirect()->route('user.programme.booking.checkout', $booking->id)->with(['success' => TranslationHelper::translate('Your Request Has Been Sent Successfully .. You Can Pay Now')]);
        } else {
            return redirect()->back()->with(['error' => 'This Programme is Not Available']);
        }
    }


}
