<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Http\Requests\Front\Search\HotelSearchRequest;
use Carbon\Carbon;
use Illuminate\Http\Request;

class HotelController extends Controller
{


    // Start Hotel Search

    public function searchHotelQuery(HotelSearchRequest $request)
    {
        $query = [
            'CityName' => '',
            'CityCode' => $request->destination,
            'nationality' => $request->nationality_id,
            'CityId' => '',
            'checkinDate' => Carbon::parse($request->hotel_check_in)->format('d-M-Y'),
            'checkoutDate' => Carbon::parse($request->hotel_check_out)->format('d-M-Y'),


            'lc' => 'en',
            'HC' => '',
            'StarRatings' => '',
            'MealTypes' => '',
            'FreeCancellation' => 'false',
            'Lat' => 0,
            'Long' => 0,
            'is_around_current_location' => 'false',

        ];

        $adults = $request->adult_number;
        $childs = $request->child_number;

        foreach ($adults as $key => $room) {
            $query['room'. ($key+1)] = $adults[$key].'-'.$childs[$key];
        }

        $queryString = http_build_query($query);
        return redirect()->route('hotel.search.result', $queryString);
    }


    public function hotelSearch(Request $request)
    {
//        return $request;
        $baseUrl = "https://www.flyaram.com/hotel/result";
        $queryString = http_build_query($request->all());
        $url = $baseUrl . '?' . $queryString;
        return view('front.pages.result', get_defined_vars());

    }


    // End Hotel Search

}
