<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Http\Requests\Front\Flight\FlightMultiSearchRequest;
use App\Http\Requests\Front\Flight\FlightSearchRequest;
use App\Models\AirMaster;
use App\Models\Airport;
use Carbon\Carbon;
use Illuminate\Http\Request;

class FlightController extends Controller
{


    // Search One Trip or Round Trip
    public function search(FlightSearchRequest $request)
    {
        if ($request->has('type') && $request->type == '1') {
//            return $air_master_from = AirMaster::with('city')->find($request->air_master_id_from);
//            $air_master_to = AirMaster::with('city')->find($request->air_master_id_to);

            $air_master_from = Airport::where('air_id', $request->air_master_id_from)->first();
            $air_master_to = Airport::where('air_id', $request->air_master_id_to)->first();
            $timestamp = Carbon::now()->timestamp * 1000;

            $query = [
                'dep1' => $air_master_from->air_code ?? 'CAI',
                'ret1' => $air_master_to->air_code ?? 'AUH',
                'dtt1' => Carbon::parse($request->flight_date)->format('d-M-Y'), // "24-Sep-2024"
                'cl1' => $request->class, // Economy , Business
                'triptype' => 1, // one way = 1 , Round trip = 2 , multi = 3
                'adult' => isset($request->adult_number) && intval($request->adult_number) > '0' ? $request->adult_number : '1',
                'child' => isset($request->child_number) && intval($request->child_number) > '0' ? $request->child_number : '0',
                'infant' => isset($request->infants_number) && intval($request->infants_number) > '0' ? $request->infants_number : '0',
                'direct' => 'false',
                'baggage' => 'false',
                'ref' => 'false',
                'umrah' => 'false',
                'key' => $request->type_key, // one way = OW , Round trip = IRT , multi = NMC
                'airlines' => '',
                'lc' => 'EN',
                'ipc' => 'false',
                'currtime' => $timestamp
            ];

            $queryString = http_build_query($query);
            return redirect()->route('flight.search.result', $queryString);
        }

        if ($request->has('type') && $request->type == '2') {
//            return $request;
            $air_master_from = Airport::where('air_id', $request->air_master_id_from)->first();
            $air_master_to = Airport::where('air_id', $request->air_master_id_to)->first();

            $timestamp = Carbon::now()->timestamp * 1000;
            $dates = explode(' - ', $request->daterange);
            $go_date = Carbon::parse($dates[0])->format('d-M-Y');
            $return_date = Carbon::parse($dates[1])->format('d-M-Y');
//            return $return_date;
            $query = [
                'dep1' => $air_master_from->air_code ?? 'CAI',
                'ret1' => $air_master_to->air_code ?? 'AUH',
                'dtt1' => $go_date, // "24-Sep-2024"
                'cl1' => $request->class, // Economy , Business

                'ret2' => $air_master_from->air_code ?? 'CAI',
                'dep2' => $air_master_to->air_code ?? 'AUH',
                'dtt2' => $return_date, // "24-Sep-2024"
                'cl2' => $request->class, // Economy , Business


                'triptype' => 2, // one way = 1 , Round trip = 2 , multi = 3
                'adult' => isset($request->adult_number) && intval($request->adult_number) > '0' ? $request->adult_number : '1',
                'child' => isset($request->child_number) && intval($request->child_number) > '0' ? $request->child_number : '0',
                'infant' => isset($request->infants_number) && intval($request->infants_number) > '0' ? $request->infants_number : '0',
                'direct' => 'false',
                'baggage' => 'false',
                'ref' => 'false',
                'umrah' => 'false',
                'key' => $request->type_key, // one way = OW , Round trip = IRT , multi = NMC
                'airlines' => '',
                'lc' => 'EN',
                'ipc' => 'false',
                'currtime' => $timestamp
            ];

            $queryString = http_build_query($query);
            return redirect()->route('flight.search.result', $queryString);
        }
    }

    // Search Multiple Trips
    public function searchMulti(FlightMultiSearchRequest $request)
    {
//        return $request;

//    return $query;

        $timestamp = Carbon::now()->timestamp * 1000;

        $query = [
            'triptype' => 1, // one way = 1 , Round trip = 2 , multi = 3
            'adult' => isset($request->adult_number) && intval($request->adult_number) > '0' ? $request->adult_number : '1',
            'child' => isset($request->child_number) && intval($request->child_number) > '0' ? $request->child_number : '0',
            'infant' => isset($request->infants_number) && intval($request->infants_number) > '0' ? $request->infants_number : '0',
            'direct' => 'false',
            'baggage' => 'false',
            'ref' => 'false',
            'umrah' => 'false',
            'key' => $request->type_key, // one way = OW , Round trip = IRT , multi = NMC
            'airlines' => '',
            'lc' => 'EN',
            'ipc' => 'false',
            'currtime' => $timestamp
        ];
        foreach ($request->air_master_id_from as $key => $value) {
            $air_master_from = Airport::where('air_id', $request->air_master_id_from)->first();
            $air_master_to = Airport::where('air_id', $request->air_master_id_to)->first();
            $date = $request->daterange_single[$key];

            $key = $key + 1;
            $query['dep' . $key] = $air_master_from->air_code ?? 'CAI';
            $query['ret' . $key] = $air_master_to->air_code ?? 'AUH';
            $query['dtt' . $key] = Carbon::parse($date)->format('d-M-Y');
            $query['cl' . $key] = $request->class;
        }
//        return $query;

        $queryString = http_build_query($query);
        return redirect()->route('flight.search.result', $queryString);
    }

    public function flightSearch(Request $request)
    {
//        return $request;
        $baseUrl = "https://www.flyaram.com/flight/search";
        $queryString = http_build_query($request->all());
        $url = $baseUrl . '?' . $queryString;
        return view('front.pages.result', get_defined_vars());
//        return redirect($url);
    }
}
